#!/bin/bash

## Parameter: choose one interface that has IPv4 connectivity (possibly through a modem/router)
interface="br0"


echo "|---------------------------------|"
echo "| IPv6to4 Setup script for Fedora |"
echo "|---------------------------------|"

echo "Getting IP info..."
ipv4_internal=$(/sbin/ifconfig $interface | grep "inet " | awk '{print $2}')
echo "Interface IP: $ipv4_internal"
ipv4_external=$(curl -sf http://ipecho.net/plain; echo)
echo "External (ISP) IP: $ipv4_external"
ipv4to6addr=$(printf "2002:%02x%02x:%02x%02x::1" `echo $ipv4_external | tr "." " "`)
echo "External 6to4 IP: $ipv4to6addr"

echo "Check that the above IPs are correct and press Enter to continue..."
read

set -e
echo "Setting up links and routes..."
/sbin/ip tunnel add tun6to4 mode sit remote any local $ipv4_internal
/sbin/ip link set dev tun6to4 up
/sbin/ip -6 addr add "$ipv4to6addr/16" dev tun6to4
/sbin/ip -6 route add 2000::/3 via ::192.88.99.1 dev tun6to4 metric 1
echo "All set up, enjoy!"

exit 0
